<?php

//***********************************************************
//*
//* counter.php - a PHP Counter script
//* (c) Hitech scripts 2003
//* For more information, visit http://www.hitech-scripts.com
//*
//***********************************************************

// Configuration section--------------------------------
$img = "counter.gif";
$data_dir = "counter_data";
$site_name = "Barbara Haczewska";
$site_url = "http://barbara.haczewska.pl/";
$title = "Hitech simple counter";
$enable_view = 1;                     //Enable view stats counter.php?action=view
//------------------------------------------------------
$ref=$HTTP_GET_VARS['ref'];


// Don't change the lines below !!!

if ($data_dir != "")   {
   if (!is_dir($data_dir)) {
      mkdir ($data_dir, 0775);
   } 
   $data_dir = $data_dir . '/';
//   chgrp ($data_dir, marekh);
}

$hour = date("H");
$hour_1 = date("H");
$day = date("d");
$month = date("m");
$year = date("Y");
$min = date("i");



if ($min == "00")  {   $min = 1;   }  
if ($min == "01")  {   $min = 1;   }
if ($min == "02")  {   $min = 2;   }
if ($min == "03")  {   $min = 3;   }
if ($min == "04")  {   $min = 4;   }
if ($min == "05")  {   $min = 5;   }
if ($min == "06")  {   $min = 6;   }
if ($min == "07")  {   $min = 7;   }
if ($min == "08")  {   $min = 8;   }
if ($min == "09")  {   $min = 9;   }

if ($hour_1 == "00")  {   $hour_1 = 0;   }  
if ($hour_1 == "01")  {   $hour_1 = 1;   }
if ($hour_1 == "02")  {   $hour_1 = 2;   }
if ($hour_1 == "03")  {   $hour_1 = 3;   }
if ($hour_1 == "04")  {   $hour_1 = 4;   }
if ($hour_1 == "05")  {   $hour_1 = 5;   }
if ($hour_1 == "06")  {   $hour_1 = 6;   }
if ($hour_1 == "07")  {   $hour_1 = 7;   }
if ($hour_1 == "08")  {   $hour_1 = 8;   }
if ($hour_1 == "09")  {   $hour_1 = 9;   }

$filename_hour = $data_dir . $month . '.' . $day . '.' . $year . '_hour.txt';
$filename_day = $data_dir . $year . '_day.txt';
$filename_year = $data_dir . 'year.txt';

$filename_ref_hour = $data_dir . $month . '.' . $day . '.' . $year . '_' . $hour . '_ref.txt';
$filename_ip_hour = $data_dir . $month . '.' . $day . '.' . $year . '_' . $hour . '_ip.txt';

$filename_ref_day = $data_dir . $month . '.' . $day . '.' . $year . '_ref.txt';
$filename_ip_day = $data_dir . $month . '.' . $day . '.' . $year . '_ip.txt';

if ($action == "view" && $enable_view == 1)   {
   
   if ($viewday != "")   {
      $checker = explode(".", $viewday);
	  if (IsSet($checker[0]))   { $month = $checker[0]; }
	  if (IsSet($checker[1]))   { $day = $checker[1]; }
	  if (IsSet($checker[2]))   { $year = $checker[2]; }
   }
   
   $title_stat = "";
   
   $header = get_header($title_stat);
   $stat = get_stat($filename);
   $footer = get_footer();
   
   echo $header;
   echo $stat;
   echo $footer;
   
   exit;
}

if ($action == "view_referers" && $enable_view == 1)   {
   if ($viewday != "")   {
      $checker = explode(".", $viewday);
	  if (IsSet($checker[0]))   { $month = $checker[0]; }
	  if (IsSet($checker[1]))   { $day = $checker[1]; }
	  if (IsSet($checker[2]))   { $year = $checker[2]; }
   }

   $header = get_header($title_stat);
   $stat = get_refs(1);
   $footer = get_footer();
   
   echo $header;
   echo $stat;
   echo $footer;

   exit;
}

if ($action == "view_referers_day" && $enable_view == 1)   {
   if ($viewday != "")   {
      $checker = explode(".", $viewday);
	  if (IsSet($checker[0]))   { $month = $checker[0]; }
	  if (IsSet($checker[1]))   { $day = $checker[1]; }
	  if (IsSet($checker[2]))   { $year = $checker[2]; }
   }

   $header = get_header($title_stat);
   $stat = get_refs(0);
   $footer = get_footer();
   
   echo $header;
   echo $stat;
   echo $footer;

   exit;
}

if ($action == "view_hosts" && $enable_view == 1)   {
   if ($viewday != "")   {
      $checker = explode(".", $viewday);
	  if (IsSet($checker[0]))   { $month = $checker[0]; }
	  if (IsSet($checker[1]))   { $day = $checker[1]; }
	  if (IsSet($checker[2]))   { $year = $checker[2]; }
   }

   $header = get_header($title_stat);
   $stat = get_refs(3);
   $footer = get_footer();
   
   echo $header;
   echo $stat;
   echo $footer;

   exit;
}

if ($action == "view_hosts_day" && $enable_view == 1)   {
   if ($viewday != "")   {
      $checker = explode(".", $viewday);
	  if (IsSet($checker[0]))   { $month = $checker[0]; }
	  if (IsSet($checker[1]))   { $day = $checker[1]; }
	  if (IsSet($checker[2]))   { $year = $checker[2]; }
   }

   $header = get_header($title_stat);
   $stat = get_refs(2);
   $footer = get_footer();
   
   echo $header;
   echo $stat;
   echo $footer;

   exit;
}

$ip = getIP();
$ip1 = $ip . "\n";

if ($ref == "")   {
   $ref = "unknown\n";
}
else  {
   $ref = $ref . "\n";
}

$is_uniq_hour = 1;
$is_imp_hour = 1;
$is_imp_year = 0;
$is_uniq_year = 1;

if (is_writable($filename_ip_hour)) {
   if (trace_hit($ip, $filename_ip_hour))  {
      $is_uniq_hour = 0;
      $is_imp_hour = 1;
      $is_uniq_year = 0;
      $is_imp_year = 1;
   }
}

$is_uniq_day = 1;
$is_imp_day = 1;

if (is_writable($filename_ip_day)) {
   if (trace_hit($ip, $filename_ip_day))  {
      $is_uniq_day = 0;
      $is_imp_day = 1;
      $is_uniq_year = 0;
      $is_imp_year = 1;   
   }
}

if (is_writable($filename_ref_hour)) {
   $file = @fopen($filename_ref_hour, "a");
   fwrite($file, $ref);
   fclose($file);
}
else  {
   $file = @fopen($filename_ref_hour, "w");
   fwrite($file, $ref);
   fclose($file);
   chmod ($filename_ref_hour, 0775);
}

if (is_writable($filename_ip_hour)) {
   $file = @fopen($filename_ip_hour, "a");
   fwrite($file, $ip1);
   fclose($file);
}
else  {
   $file = @fopen($filename_ip_hour, "w");
   fwrite($file, $ip1);
   fclose($file);
   chmod ($filename_ip_hour, 0775);
}

if (is_writable($filename_ref_day)) {
   $file = @fopen($filename_ref_day, "a");
   fwrite($file, $ref);
   fclose($file);
}
else  {
   $file = @fopen($filename_ref_day, "w");
   fwrite($file, $ref);
   fclose($file);
   chmod ($filename_ref_day, 0775);
}

if (is_writable($filename_ip_day)) {
   $file = @fopen($filename_ip_day, "a");
   fwrite($file, $ip1);
   fclose($file);
}
else  {
   $file = @fopen($filename_ip_day, "w");
   fwrite($file, $ip1);
   fclose($file);
   chmod ($filename_ip_day, 0775);
}

// Hour stats calculation ---------------------------------------
$imp_av = 0;
$uniq_av = 0;
$rel_av = 0;
$ret_av = 0;			     

if (is_writable($filename_hour)) {
   $hour_stat_array = file($filename_hour);
   $count = count($hour_stat_array);
   $count = $count - 1;
   
   if ($count != $hour_1)  {
      $emp = $hour_1 - $count;
	  for ($i = 1; $i <= $emp; $i++) {
	     
		 $count = count($hour_stat_array);       
		 for ($j = 0; $j <= $count - 1; $j++) {
            $checker = explode("|", $hour_stat_array[$j]);
			$imp_av = $imp_av + $checker[0];
            $uniq_av = $uniq_av + $checker[1];
            $rel_av = $rel_av + $checker[2];
            $ret_av = $ret_av + $checker[3];		 
		 }
		 if ($count != 0)   {
		    $imp_av = round($imp_av/$count);
            $uniq_av = round($uniq_av/$count);
            $rel_av = round($rel_av/$count);
            $ret_av = round($ret_av/$count);		 		 
	     }
		 else   {
		    $imp_av = 0;
            $uniq_av = 0;
            $rel_av = 0;
            $ret_av = 0;			 
		 }
		 
		 array_push($hour_stat_array, '0|0|0|0|0|0|0|0|' . $imp_av . '|' . $uniq_av . '|' . $rel_av . '|' . $ret_av . "\n");
	  }
	  $result = '0|0|0|0|0|0|0|0|' . $imp_av . '|' . $uniq_av . '|' . $rel_av . '|' . $ret_av; 
   }
   else  {
      $result = "";
      $result = $hour_stat_array[$hour_1];
   }
       
   $checker = explode("|", $result);
   
   $imp = $checker[0] + $is_imp_hour;
   $uniq = $checker[1] + $is_uniq_hour;
   $rel = $checker[2] + $is_reload_hour;
   $ret = $checker[3] + $is_return_hour;

   $imp_h_f = round(($imp/$min)*60);
   $uniq_h_f = round(($uniq/$min)*60);
   $rel_h_f = round(($rel/$min)*60);
   $ret_h_f = round(($ret/$min)*60);

   $count = count($hour_stat_array);       
   for ($j = 0; $j <= $count - 1; $j++) {
            $checker = explode("|", $hour_stat_array[$j]);
			$imp_av = $imp_av + $checker[0];
            $uniq_av = $uniq_av + $checker[1];
            $rel_av = $rel_av + $checker[2];
            $ret_av = $ret_av + $checker[3];		 
   }
   if ($count != 0)   {
		    $imp_av = round($imp_av/$count);
            $uniq_av = round($uniq_av/$count);
            $rel_av = round($rel_av/$count);
            $ret_av = round($ret_av/$count);		 		 
   }
   else   {
		    $imp_av = 0;
            $uniq_av = 0;
            $rel_av = 0;
            $ret_av = 0;			 
   }
     
   $res = $imp . '|' . $uniq . '|' . $rel . '|' . $ret . '|' . $imp_h_f . '|' . $uniq_h_f . '|' . $rel_h_f . '|' . $ret_h_f . '|' . $imp_av . '|' . $uniq_av . '|' . $rel_av . '|' . $ret_av . "\n";
   $hour_stat_array[$hour_1] = $res;
   	 
   $file = @fopen($filename_hour, "w");
   $hour_stat_array= implode("", $hour_stat_array);
   fwrite($file, $hour_stat_array);
   fclose($file);
   chmod ($filename_hour, 0775);	 
}
else   {
   $count = 0;
   $hour_stat_array[] = "";
   
   if ($count != $hour_1)  {
      $emp = $hour_1 - $count;
	  for ($i = 1; $i <= $emp; $i++) {
	     
		 $count = count($hour_stat_array);       
		 for ($j = 0; $j <= $count - 1; $j++) {
            $checker = explode("|", $hour_stat_array[$j]);
			$imp_av = $imp_av + $checker[0];
            $uniq_av = $uniq_av + $checker[1];
            $rel_av = $rel_av + $checker[2];
            $ret_av = $ret_av + $checker[3];		 
		 }
		 if ($count != 0)   {
		    $imp_av = round($imp_av/$count);
            $uniq_av = round($uniq_av/$count);
            $rel_av = round($rel_av/$count);
            $ret_av = round($ret_av/$count);		 		 
	     }
		 else   {
		    $imp_av = 0;
            $uniq_av = 0;
            $rel_av = 0;
            $ret_av = 0;			 
		 }
		 
		 array_push($hour_stat_array, '0|0|0|0|0|0|0|0|' . $imp_av . '|' . $uniq_av . '|' . $rel_av . '|' . $ret_av . "\n");
	  }
   }
   $file = @fopen($filename_hour, "w");

   
   $imp_h_f = round((1/$min)*60);
   $uniq_h_f = round((1/$min)*60);
   $rel_h_f = round((1/$min)*60);
   $ret_h_f = round((1/$min)*60);
      
   $res = '1|1|1|1' . '|' . $imp_h_f . '|' . $uniq_h_f . '|' . $rel_h_f . '|' . $ret_h_f . '|1|1|1|1' . "\n";
   array_push($hour_stat_array, $res);
   $hour_stat_array= implode("", $hour_stat_array);
   fwrite($file, $hour_stat_array);
   fclose($file);
   chmod ($filename_hour, 0775);	   
}
//End hour stats calculation---------------------------------------------
$viewday_ = $month . '.' . $day . '.' . $year;
if (is_writable($filename_day)) {
   $day_stat_array = file($filename_day);
   $count = count($day_stat_array);
   if ($count != 0)  {    $count = $count - 1;  }
  
   $curr_day = $count;

   $imp_av = 0;
   $uniq_av = 0;
   $rel_av = 0;
   $ret_av = 0;		
   
   $curr_day_finded = -1;   
   for ($i = 0; $i <= $count; $i++) {
      $checker = explode("|", $day_stat_array[$i]);
	  if ($viewday_ == $checker[0]) {  $curr_day_finded = $i;  }
   } 
   
   if ($curr_day_finded == -1)   {
      $res = $viewday_ . '|' . '0|0|0|0|0|0|0|0|0|0|0|0' . "\n";
      array_push($day_stat_array, $res);
	  $count = count($day_stat_array);
	  $curr_day = $count - 1;
   }
   else  {
      $curr_day = $curr_day_finded;
   }
     
   $result = $day_stat_array[$curr_day];   
   $checker = explode("|", $result); 
   
   $imp = round($checker[1] + $is_imp_day);
   $uniq = round($checker[2] + $is_uniq_day);
   $rel = round($checker[3] + $is_reload_hour);
   $ret = round($checker[4] + $is_return_hour);

   $imp_av = $imp_av + $is_imp_day;
   $uniq_av = $uniq_av + $is_uniq_day;
   $rel_av = $rel_av + $is_reload_hour;
   $ret_av = $ret_av + $is_return_hour;		
   
   $imp_h_f = round(($imp/($hour_1*60 + $min))*3600);
   $uniq_h_f = round(($uniq/($hour_1*60 + $min))*3600);
   $rel_h_f = round(($rel/($hour_1*60 + $min))*3600);
   $ret_h_f = round(($ret/($hour_1*60 + $min))*3600);

   $count = count($day_stat_array);       
   for ($j = 0; $j <= $count - 1; $j++) {
            $checker = explode("|", $day_stat_array[$j]);
			$imp_av = $imp_av + $checker[1];
            $uniq_av = $uniq_av + $checker[2];
            $rel_av = $rel_av + $checker[3];
            $ret_av = $ret_av + $checker[4];		 
   }
   if ($count != 0)   {
		    $imp_av = round($imp_av/$count);
            $uniq_av = round($uniq_av/$count);
            $rel_av = round($rel_av/$count);
            $ret_av = round($ret_av/$count);		 		 
   }
   else   {
		    $imp_av = 0;
            $uniq_av = 0;
            $rel_av = 0;
            $ret_av = 0;			 
   }
   
   $day_stat_array[$curr_day] = $viewday_ . '|' . $imp . '|' . $uniq . '|' . $rel . '|' . $ret . '|' . $imp_h_f . '|' . $uniq_h_f . '|' . $rel_h_f . '|' . $ret_h_f . '|' . $imp_av . '|' . $uniq_av . '|' . $rel_av . '|' . $ret_av . "\n";
   	 
   $file = @fopen($filename_day, "w");
   $day_stat_array= implode("", $day_stat_array);
   fwrite($file, $day_stat_array);
   fclose($file);
   chmod ($filename_day, 0775);	 
}
else   {
   $file = @fopen($filename_day, "w");
   
   $imp_h_f = round(($imp/($hour_1*60 + $min))*3600);
   $uniq_h_f = round(($uniq/($hour_1*60 + $min))*3600);
   $rel_h_f = round(($rel/($hour_1*60 + $min))*3600);
   $ret_h_f = round(($ret/($hour_1*60 + $min))*3600);
      
   $res = $viewday_ . '|' . '1|1|1|1' . '|' . $imp_h_f . '|' . $uniq_h_f . '|' . $rel_h_f . '|' . $ret_h_f . '|1|1|1|1' . "\n";
   fwrite($file, $res);
   fclose($file);
   chmod ($filename_day, 0775);	   
}

if (is_writable($filename_year)) {
   $year_stat_array = file($filename_year);
   $count = count($year_stat_array);
   if ($count != 0)  {    $count = $count - 1;  }
  
   $curr_year = $count;

   $imp_av = 0;
   $uniq_av = 0;
   $rel_av = 0;
   $ret_av = 0;		
      
   for ($i = 0; $i <= $count; $i++) {
      $checker = explode("|", $year_stat_array[$j]);
	  if ($year == $checker[0]) {  $curr_year = $i;  }
   } 
     
   $result = $year_stat_array[$curr_year];   
   $checker = explode("|", $result); 
   
   $imp = $checker[1] + $is_imp_year;
   $uniq = $checker[2] + $is_uniq_year;
   $rel = $checker[3] + $is_reload_hour;
   $ret = $checker[4] + $is_return_hour;

   $imp_av = $imp_av + $is_imp_year;
   $uniq_av = $uniq_av + $is_uniq_year;
   $rel_av = $rel_av + $is_reload_hour;
   $ret_av = $ret_av + $is_return_hour;		
   
   $imp_y_f = round(($imp/($hour_1*60 + $min + ($day + 30*($month - 1))*24*60))*3600*24*365);
   $uniq_y_f = round(($uniq/($hour_1*60 + $min + ($day + 30*($month - 1))*24*60))*3600*24*365);
   $rel_y_f = round(($rel/($hour_1*60 + $min + ($day + 30*($month - 1))*24*60))*3600*24*365);
   $ret_y_f = round(($ret/($hour_1*60 + $min + ($day + 30*($month - 1))*24*60))*3600*24*365);

   $count = count($year_stat_array);       
   for ($j = 0; $j <= $count - 1; $j++) {
            $checker = explode("|", $year_stat_array[$j]);
			$imp_av = $imp_av + $checker[1];
            $uniq_av = $uniq_av + $checker[2];
            $rel_av = $rel_av + $checker[3];
            $ret_av = $ret_av + $checker[4];		 
   }
   if ($count != 0)   {
		    $imp_av = round($imp_av/$count);
            $uniq_av = round($uniq_av/$count);
            $rel_av = round($rel_av/$count);
            $ret_av = round($ret_av/$count);		 		 
   }
   else   {
		    $imp_av = 0;
            $uniq_av = 0;
            $rel_av = 0;
            $ret_av = 0;			 
   }
   
   $year_stat_array[$curr_year] = $year . '|' . $imp . '|' . $uniq . '|' . $rel . '|' . $ret . '|' . $imp_y_f . '|' . $uniq_y_f . '|' . $rel_y_f . '|' . $ret_y_f . '|' . $imp_av . '|' . $uniq_av . '|' . $rel_av . '|' . $ret_av . "\n";
   	 
   $file = @fopen($filename_year, "w");
   $year_stat_array = implode("", $year_stat_array);
   fwrite($file, $year_stat_array);
   fclose($file);
   chmod ($filename_year, 0775);	 
}
else   {
   $imp_y_f = round(($imp/($hour_1*60 + $min + ($day + 30*($month - 1))*24*60))*3600*24*365);
   $uniq_y_f = round(($uniq/($hour_1*60 + $min + ($day + 30*($month - 1))*24*60))*3600*24*365);
   $rel_y_f = round(($rel/($hour_1*60 + $min + ($day + 30*($month - 1))*24*60))*3600*24*365);
   $ret_y_f = round(($ret/($hour_1*60 + $min + ($day + 30*($month - 1))*24*60))*3600*24*365);
      
   $res = $year . '|' . '1|1|1|1' . '|' . $imp_y_f . '|' . $uniq_y_f . '|' . $rel_y_f . '|' . $ret_y_f . '|1|1|1|1' . "\n";

   $file = @fopen($filename_year, "w");  
   fwrite($file, $res);
   fclose($file);	
   chmod ($filename_year, 0775);   
}

setcookie("is_reload_hour", 1, 0);
setcookie("is_return_hour", 1, 3600);

header("Location: $img");

exit;
//----------------------------------------------------------------------------------------------
function trace_hit($ip, $filename) {  
   $data_array = file($filename);
  
   if (in_array("$ip\n", $data_array) || !$ip) {
      return true;
   }	  
   else {
      return false;
   }
}
//----------------------------------------------------------------------------------------------
function chomp($String) 
{ 
  $TheEnd = strchr($String, "\n"); 
  $Result=substr($String, 0, $TheEnd - 1); 
  return $Result; 
} 
//----------------------------------------------------------------------------------------------
function getIP() {  
   $ip;
   if (getenv("HTTP_CLIENT_IP")) $ip = getenv("HTTP_CLIENT_IP");
   else if(getenv("HTTP_X_FORWARDED_FOR")) $ip = getenv("HTTP_X_FORWARDED_FOR");
   else if(getenv("REMOTE_ADDR")) $ip = getenv("REMOTE_ADDR");
   else $ip = "UNKNOWN";
   
   return $ip;
}
//----------------------------------------------------------------------------------------------
function get_stat($filename)   {
   global $site_name, $data_dir, $hour, $day, $month, $year, $min, $hour_1;
   $date = date ("l dS of F Y h:i:s A");
   
   $viewday_ = $month . '.' . $day . '.' . $year;

   $day_ = date("d");
   $month_ = date("m");
   $year_ = date("Y");
   
   $viewday_1 = $month_ . '.' . $day_ . '.' . $year_;
      
   $filename_hour = $data_dir . $month . '.' . $day . '.' . $year . '_hour.txt';
   $filename_day = $data_dir . $year . '_day.txt';
   $filename_year = $data_dir . 'year.txt';

   if (is_writable($filename_hour)) {
      $hour_stat_array = file($filename_hour);      
      $count = count($hour_stat_array);
      if ($count != 0)  {    $count = $count - 1;  }
   
	  if ($count == $hour_1)  {   $result = $hour_stat_array[$hour_1];  $result = chomp($result); }
	  else { $result = "0|0|0|0|0|0|0|0|0|0|0|0"; }
	  
      $checker = explode("|", $result);
   
      $imp_h = $checker[0];
      $uniq_h = $checker[1];
      $rel_h = $checker[2];
      $ret_h = $checker[3];
	  
	  $imp_h_av = $checker[8];
	  $uniq_h_av = $checker[9];
	  $rel_h_av = $checker[10];
	  $ret_h_av = $checker[11];
	  
	  if ($imp_h_av == 0)  {  $imp_h_av = $imp_h; }
	  if ($uniq_h_av == 0)  {  $uniq_h_av = $uniq_h; }
	  if ($rel_h_av == 0)  {  $rel_h_av = $rel_h; }
	  if ($ret_h_av == 0)  {  $ret_h_av = $ret_h; }
	  
	  if ($viewday_ == $viewday_1)  {
         $imp_h_f = round(($imp_h/$min)*60);
		 $uniq_h_f = round(($uniq_h/$min)*60);
         $rel_h_f = round(($rel_h/$min)*60);
         $ret_h_f = round(($ret_h/$min)*60);
	  }
	  else  {
         $imp_h_f = $checker[4];
         $uniq_h_f = $checker[5];
         $rel_h_f = $checker[6];
         $ret_h_f = $checker[7];	  
	  }	  	   
   }
   else   {
      $imp_h = 0;
      $uniq_h = 0;
      $rel_h = 0;
      $ret_h = 0;
      $imp_h_f = 0;
      $uniq_h_f = 0;
      $rel_h_f = 0;
      $ret_h_f = 0;
	  $imp_h_av = 0;
	  $uniq_h_av = 0;
	  $rel_h_av = 0;
	  $ret_h_av = 0;	  		     
   }
      
   if (is_writable($filename_day)) {
      $day_stat_array = file($filename_day);
      $count = count($day_stat_array);
      if ($count != 0)  {    $count = $count - 1;  }
   
      $curr_day = $count;
      $curr_day_finded = -1;
      for ($i = 0; $i <= $count; $i++) {
         $checker = explode("|", $day_stat_array[$i]);
	     if ($viewday_ == $checker[0]) {  $curr_day_finded = $i;  }
      } 
      
	  if ($curr_day_finded == -1)   {
	     $result = $res = $viewday_ . '|' . '0|0|0|0|0|0|0|0|0|0|0|0' . "\n";
	  }
	  else  {
	     $curr_day = $curr_day_finded;
		 $result = $day_stat_array[$curr_day]; 
	  }
	    
      $result = chomp($result);
      $checker = explode("|", $result);
   
      $imp_d = $checker[1];
      $uniq_d = $checker[2];
      $rel_d = $checker[3];
      $ret_d = $checker[4];

	  $imp_d_av = $checker[9];
	  $uniq_d_av = $checker[10];
	  $rel_d_av = $checker[11];
	  $ret_d_av = $checker[12];
	  
	  if ($viewday_ == $viewday_1)  {
         $imp_d_f = round(($imp_d/($hour_1*60 + $min))*3600);
         $uniq_d_f = round(($uniq_d/($hour_1*60 + $min))*3600);
         $rel_d_f = round(($rel_d/($hour_1*60 + $min))*3600);
         $ret_d_f = round(($ret_d/($hour_1*60 + $min))*3600);
	  }
	  else  {
         $imp_d_f = $checker[5];
         $uniq_d_f = $checker[6];
         $rel_d_f = $checker[7];
         $ret_d_f = $checker[8];	  
	  }	  	   	   
   }
   else   {
      $imp_d = 0;
      $uniq_d = 0;
      $rel_d = 0;
      $ret_d = 0;
      $imp_d_f = 0;
      $uniq_d_f = 0;
      $rel_d_f = 0;
      $ret_d_f = 0;
	  $imp_d_av = 0;
	  $uniq_d_av = 0;
	  $rel_d_av = 0;
	  $ret_d_av = 0;	  		     	  	     
   }

   if (is_writable($filename_year)) {
      $year_stat_array = file($filename_year);
      $count = count($year_stat_array);
      if ($count != 0)  {    $count = $count - 1;  }
   
      $curr_year = $count;

      for ($i = 0; $i <= $count; $i++) {
         $checker = explode("|", $year_stat_array[$j]);
	     if ($year == $checker[0]) {  $curr_year = $i;  }
      } 
     
      $result = $year_stat_array[$curr_year];   
      $result = chomp($result);
      $checker = explode("|", $result);
   
      $imp_y = $checker[1];
      $uniq_y = $checker[2];
      $rel_y = $checker[3];
      $ret_y = $checker[4];

      $imp_y_f = $checker[5] + 1;
      $uniq_y_f = $checker[6] + 1;
      $rel_y_f = $checker[7] + 1;
      $ret_y_f = $checker[8] + 1;	  
	  
	  $imp_y_av = $checker[9];
	  $uniq_y_av = $checker[10];
	  $rel_y_av = $checker[11];
	  $ret_y_av = $checker[12];	  
   }
   else   {
      $imp_y = 0;
      $uniq_y = 0;
      $rel_y = 0;
      $ret_y = 0;
      $imp_y_f = 0;
      $uniq_y_f = 0;
      $rel_y_f = 0;
      $ret_y_f = 0;
	  $imp_y_av = 0;
	  $uniq_y_av = 0;
	  $rel_y_av = 0;
	  $ret_y_av = 0;	  		     	  	          
   }
   
   $html = '<center><h1>Statistics information for ' . $site_name . '</h1>
<table width="350">
<tr>
       <td align=center><a href=""></a></td>
       <td align=center><a href=""></a></td>
</tr>
</table>
<br>

<div align="left">
Site title: <b><a target=_blank href="' . $site_url . '">' . $site_name . '</a></b>
<br>
Current time: <b>' . $date . '</b>
<br><br>
<table width=350>
<tr>
       <td><a href="counter.php?action=view">Main</a></td>
       <td><a href="counter.php?action=view_referers&viewday=' . $viewday_ . '">View referers</a></td>
       <td><a href="counter.php?action=view_hosts&viewday=' . $viewday_ . '">View remote hosts</a></td>
</tr>
</table>
</div>
<br>
<table width="100%">
<tr>
       <td align=center width="100%">
	   <table width="100%" border="1" bordercolor="#CCCCCC">
	   <tr bgcolor="#CCCCCC">
       <td align=center width="30%"><b>Hourly statistics</b></td>
	   <td align=center>Current</td>
	   <td align=center>Forecast</td>
	   <td align=center>Average</td>
	   </tr>
	   <tr>
       <td>Impressions</td>
       <td align=center>' . $imp_h . '</td>
	   <td align=center>' . $imp_h_f . '</td>
	   <td align=center>' . $imp_h_av . '</td>
	   </tr>
	   <tr>
       <td>Uniques</td>
       <td align=center>' . $uniq_h . '</td>
	   <td align=center>' . $uniq_h_f . '</td>
	   <td align=center>' . $uniq_h_av . '</td>	   
	   </tr>
	   <tr>
       <td>Reloads</td>
       <td align=center>' . $rel_h . '</td>
	   <td align=center>' . $rel_h_f . '</td>
	   <td align=center>' . $rel_h_av . '</td>	   
	   </tr>
	   <tr>
       <td>Hourly Returns</td>
       <td align=center>' . $ret_h . '</td>
	   <td align=center>' . $ret_h_f . '</td>
	   <td align=center>' . $ret_h_av . '</td>	   
	   </tr>
	   </table>
       <br>
	   <br>
       <table width=350 align=left>
       <tr>
          <td><a href="counter.php?action=view">Main</a></td>
          <td><a href="counter.php?action=view_referers_day&viewday=' . $viewday_ . '">View referers</a></td>
          <td><a href="counter.php?action=view_hosts_day&viewday=' . $viewday_ . '">View remote hosts</a></td>
       </tr>
       </table>	   
	   <br><br>
	   <table width="100%" border="1" bordercolor="#CCCCCC">
	   <tr bgcolor="#CCCCCC">
       <td align=center width="30%"><b>Day statistics</b></td>
	   <td align=center>Current</td>
	   <td align=center>Forecast</td>
	   <td align=center>Average</td>
	   </tr>
	   <tr>
       <td>Impressions</td>
       <td align=center>' . $imp_d . '</td>
	   <td align=center>' . $imp_d_f . '</td>
	   <td align=center>' . $imp_d_av . '</td>	   
	   </tr>
	   <tr>
       <td>Uniques</td>
       <td align=center>' . $uniq_d . '</td>
	   <td align=center>' . $uniq_d_f . '</td>
	   <td align=center>' . $uniq_d_av . '</td>	   
	   </tr>
	   <tr>
       <td>Reloads</td>
       <td align=center>' . $rel_d . '</td>
	   <td align=center>' . $rel_d_f . '</td>
	   <td align=center>' . $rel_d_av . '</td>	   
	   </tr>
	   <tr>
       <td>Daily Returns</td>
       <td align=center>' . $ret_d . '</td>
	   <td align=center>' . $ret_d_f . '</td>
	   <td align=center>' . $ret_d_av . '</td>		   
	   </tr>
	   </table>

       <br>
	   <table width="100%" border="1" bordercolor="#CCCCCC">
	   <tr bgcolor="#CCCCCC">
       <td align=center width="30%"><b>Year statistics</b></td>
	   <td align=center>Current</td>
	   <td align=center>Forecast</td>
	   <td align=center>Average</td>
	   </tr>
	   <tr>
       <td>Impressions</td>
       <td align=center>' . $imp_y . '</td>
	   <td align=center>' . $imp_y_f . '</td>
	   <td align=center>' . $imp_y_av . '</td>	   
	   </tr>
	   <tr>
       <td>Uniques</td>
       <td align=center>' . $uniq_y . '</td>
	   <td align=center>' . $uniq_y_f . '</td>
	   <td align=center>' . $uniq_y_av . '</td>	   
	   </tr>
	   <tr>
       <td>Reloads</td>
       <td align=center>' . $rel_y . '</td>
	   <td align=center>' . $rel_y_f . '</td>
	   <td align=center>' . $rel_y_av . '</td>	   
	   </tr>
	   <tr>
       <td>Yearly Returns</td>
       <td align=center>' . $ret_y . '</td>
	   <td align=center>' . $ret_y_f . '</td>
	   <td align=center>' . $ret_y_av . '</td>	   
	   </tr>
	   </table>
	   
	   </td>
</tr>
</table><br><br>';

   return $html;
}
//----------------------------------------------------------------------------------------------
function get_refs($get_mode)   {
   global $site_name, $data_dir, $hour, $day, $month, $year, $min, $hour_1;
   $date = date ("l dS of F Y h:i:s A"); 
   $viewday_ = $month . '.' . $day . '.' . $year;
   
   $filename_ref_hour = $data_dir . $month . '.' . $day . '.' . $year . '_' . $hour . '_ref.txt';
   $filename_ip_hour = $data_dir . $month . '.' . $day . '.' . $year . '_' . $hour . '_ip.txt';

   $filename_ref_day = $data_dir . $month . '.' . $day . '.' . $year . '_ref.txt';
   $filename_ip_day = $data_dir . $month . '.' . $day . '.' . $year . '_ip.txt';
      
   if ($get_mode == 0)   { $filename = $filename_ref_day; $url_ref = "view_referers_day";  $url_hosts = "view_hosts_day"; }
   if ($get_mode == 1)   { $filename = $filename_ref_hour; $url_ref = "view_referers";  $url_hosts = "view_hosts"; }
   if ($get_mode == 2)   { $filename = $filename_ip_day; $url_ref = "view_referers_day";  $url_hosts = "view_hosts_day";  }
   if ($get_mode == 3)   { $filename = $filename_ip_hour; $url_ref = "view_referers";  $url_hosts = "view_hosts"; }
      
   $html = '<center><h1>Statistics information for ' . $site_name . '</h1>
<table width="350">
<tr>
       <td align=center><a href=""></a></td>
       <td align=center><a href=""></a></td>
</tr>
</table>
<br>

<div align="left">
Site title: <b><a target=_blank href="' . $site_url . '">' . $site_name . '</a></b>
<br>
Current time: <b>' . $date . '</b>
<br><br>
<table width=350>
<tr>
       <td><a href="counter.php?action=view">Main</a></td>
       <td><a href="counter.php?action=' . $url_ref . '&viewday=' . $viewday_ . '">View referers</a></td>
       <td><a href="counter.php?action=' . $url_hosts . '&viewday=' . $viewday_ . '">View remote hosts</a></td>
</tr>
</table>

<br>';
   
   if (is_writable($filename))   {
      $ref_array = file($filename);
      for ($i = 0; $i <= count($ref_array) - 1; $i++) {
         $html = $html . '<a target=_blank href="' . $ref_array[$i] . '">' . $ref_array[$i] . '</a><br>'; 
      }
   }	
   
   $html = $html . '</div><br><br>';		      
   return $html;
}
//----------------------------------------------------------------------------------------------
function get_header($title)   { 
   $header = '<html>
<head>
	<title>' . $title . '</title>
<style>
body {font-family:verdana; font-size:8pt}
h1 {font-family:verdana; font-size:12pt}
td {font-size:8pt}

a:link { 
	color: #333333;
	}
a:visited { 
	color: #666666;
	}
a:hover { 
	color: #CCCCCC;
	background-color: #333333;
	text-decoration: none;
	}
a:active { 
	color: #333333;
	}
.border{border: 1pt solid black}


INPUT {
  COLOR: #000000; 
  BACKGROUND-COLOR: #f6f6f6;
  FONT-SIZE: 8pt;
  BORDER-BOTTOM: #333333 1px solid; 
  BORDER-LEFT:   #333333 1px solid; 
  BORDER-RIGHT:  #333333 1px solid; 
  BORDER-TOP:    #333333 1px solid 
}

SELECT {
  COLOR: #000000; 
  BACKGROUND-COLOR: #f6f6f6;
  FONT-SIZE: 8pt;
  BORDER-BOTTOM: #333333 1px solid; 
  BORDER-LEFT:   #333333 1px solid; 
  BORDER-RIGHT:  #333333 1px solid; 
  BORDER-TOP:    #333333 1px solid 
}

TEXTAREA {
  COLOR: #000000; 
  BACKGROUND-COLOR: #f6f6f6;
  FONT-SIZE: 8pt;
  BORDER-BOTTOM: #333333 1px solid; 
  BORDER-LEFT:   #333333 1px solid; 
  BORDER-RIGHT:  #333333 1px solid; 
  BORDER-TOP:    #333333 1px solid 
}
</style>		
</head>

<body>
<center><h1>' . $title . '</h1>
';
  
  return $header;
}
//-------------------------------------------------------------------------------------------------
function get_footer()   {
  $footer = '</center> <center>Powered by <a href="http://www.hitech-scripts.com">Hitech-scripts.com</a></center></body></html>';
  
  return $footer;
}
//-------------------------------------------------------------------------------------------------

?>